import java.awt.*;
import java.applet.*;
import java.util.*;
import java.net.*;
import java.io.*;

public class BasicApplet extends Applet implements Runnable
{
	// parameters for the applet
	private static Thread animThread = null;
	private static boolean dieThread;
	private static Image canvas;
	private static int mouseX = 0;
	private static int mouseY = 0;	
	
	private static boolean okay = false;
	private static final int mandatorySleepTime = 10;
	private static final int availableTimePerFrame = 23; // milliseconds; sums to 33 => 30fps
	private static int canvasWidth;
	private static int canvasHeight;
	private	static final String widthParam      = "width";
	private	static final String heightParam     = "height";
	private	static final String creditParam     = "credit";
	private	static final String backgroundParam = "background";
	private	static final String foregroundParam = "foreground";
	private static Color bgColor;
	private static Color fgColor;
	private static String creditValue;
	
	//--------------------------------------------------------------------------
	// Applet plumbing methods
	
	public void init(){ handleInit(); }
	private void handleInit(){
		authenticate();
		establishParameters();
		resize (canvasWidth, canvasHeight);
		canvas = createImage (canvasWidth, canvasHeight);
	}

	public void start(){ handleStart(); }
	private void handleStart(){
		dieThread = false;
		requestFocus();
		if (animThread == null){ 
			animThread = new Thread (this);
			animThread.start();
		} 
	}
	
	public void stop(){ handleStop(); }
	private void handleStop(){ 
		dieThread = true;
		if (animThread != null){
			animThread.stop();
			animThread = null;
		}
	}
	
	public void destroy(){;}
	public void update(Graphics g) { paint(g);}
	public void update(){ 
		paint(this.getGraphics());
	}
	
	public void run(){ handleRun(); }
	private void handleRun(){ 
		while (animThread != null) {
			long then = System.currentTimeMillis();
			//if (okay){ doSimulation(); }
			update(); 
			try {
				if (!dieThread) { // includes dynamic sleep by Tom White
					 try {Thread.sleep(mandatorySleepTime);} 
					 // sleep for a minimum of mandatorySleepTime millisecs per frame
					 catch(InterruptedException e){}
					 long now = System.currentTimeMillis(); 
					 int napTime = (int) (availableTimePerFrame - (now - then)); 
					 // sleep or work for at least availableTimePerFrame more
					 if (napTime > 0) {
						 try { Thread.sleep(napTime);}
						 catch (InterruptedException e) {}
					 }
				} else {
					if (animThread != null) {
						animThread.stop();
						animThread = null;
						break;
					}
				}
			} catch (Exception e) { break;}
		}
	}
	
	
	private void establishParameters() {
		this.setBackground(Color.darkGray);
		this.setForeground(Color.lightGray);
		bgColor = Color.darkGray;
		fgColor = Color.lightGray;
		canvasWidth = 320;
		canvasHeight = 240;
		
		final String defaultWidth = "320";
		final String defaultHeight = "240";
		final String defaultBackground = "000000";
		final String defaultForeground = "FFFFFF";

		String widthValue;
		String heightValue;
		String backgroundValue;
		String foregroundValue;

		widthValue      = getParameter(widthParam);
		heightValue     = getParameter(heightParam);
		backgroundValue = getParameter(backgroundParam);
		foregroundValue = getParameter(foregroundParam);
		
		if (widthValue == null)     { widthValue = defaultWidth; }
		if (heightValue == null)    { heightValue = defaultHeight; }
		if (backgroundValue == null) { backgroundValue = defaultBackground; }
		if (foregroundValue == null) { foregroundValue = defaultForeground; }

		canvasWidth  = Integer.parseInt(widthValue);
		canvasHeight = Integer.parseInt(heightValue);
		bgColor = stringToColor(backgroundValue);
		fgColor = stringToColor(foregroundValue);
		this.setBackground(bgColor);
		this.setForeground(fgColor);
	}
	
	private Color stringToColor(String paramValue) {
		// Converts a string formatted as "rrggbb" to an awt.Color object
		int red, green, blue;
		red   = (Integer.decode("0x" + paramValue.substring(0,2))).intValue();
		green = (Integer.decode("0x" + paramValue.substring(2,4))).intValue();
		blue  = (Integer.decode("0x" + paramValue.substring(4,6))).intValue();
		return new Color(red, green, blue);
	}
	
	
	private void authenticate(){
		okay = false;
		boolean accreditation = false;
		
		// make sure the accreditation is correct in the html page parameter
		creditValue	= getParameter(creditParam);
		if ((creditValue.hashCode() == (68625034*2)) &&
			(creditValue.length() == (30+9))){ accreditation = true; }
		else { 
			accreditation = false;
			creditValue = "no good. credit parameter has been modified.";
			System.out.println(creditValue);
		}
		
		
		if (accreditation==true) { okay = true; }
	}
	
	
	//--------------------------------------------------------------------------
	public synchronized void paint(Graphics g) { handlePaint(g); }
	private synchronized void handlePaint(Graphics g) {
		if (okay){
			try { 
				Graphics tempGC = canvas.getGraphics();	
				clearCanvas(tempGC);
				drawSimulation(tempGC);
				g.drawImage(canvas, 0, 0, this);
			} 
			catch (NullPointerException e) { 
				System.out.println("error:  "  +  e.getMessage());
			}
		} else { // applet not OK
			try { 
				Graphics tempGC = canvas.getGraphics();	
				clearCanvas(tempGC);
				g.drawImage(canvas, 0, 0, this);
			}
			catch (NullPointerException e) { 
				System.out.println("error:  "  +  e.getMessage());
			}
			this.getAppletContext().showStatus(creditValue);
		}
	}
	

	private void clearCanvas(Graphics tempGC) {
		tempGC.setColor(bgColor);
		tempGC.fillRect(0, 0, canvasWidth, canvasHeight);
	}
	
	
	private void drawSimulation(Graphics tempGC){
		int r  = 10;
		int d  = r*2;
		int px = mouseX - r;
		int py = mouseY - r;
		tempGC.setColor(fgColor);
		tempGC.fillOval(px, py, d, d);
	}
	

	
	//--------------------------------------------------------------------------
	// interaction methods
	public boolean mouseDown (Event evt, int x, int y){ handleMouseDown(x, y); return true; }
	private void handleMouseDown (int x, int y){ mouseX = x; mouseY = y; }
	
	public boolean mouseUp   (Event evt, int x, int y){ handleMouseUp(x, y);   return true; }
	private void handleMouseUp (int x, int y){ mouseX = x; mouseY = y; }
	
	public boolean mouseMove (Event evt, int x, int y){ handleMouseMove(x, y); return true; }
	private void handleMouseMove (int x, int y){ mouseX = x; mouseY = y; }
	
	public boolean mouseDrag (Event evt, int x, int y){ handleMouseDrag(x, y); return true; }
	private void handleMouseDrag (int x, int y){ mouseX = x; mouseY = y; }
	
	public boolean keyDown(Event evt, int code) { handleKeyDown(evt, code);    return true;}
	private void handleKeyDown(Event evt, int code) {
		if ((code == 13) || (code == 10)) { // return,newline,enter
			;
		} else { 
			switch ((char)code){
			case ' ': break;
			}
		}
	}
	
	
}
